function errors = mispricing_tranches(c, tranche_structure, r_term, ajd_common_factor, N, dz)
% --------------------------------------------------------------------------------------------------
% Wrapper function that calculates the weighted average tranche squared pricing error for a credit
% default swap. The first argument overwrites the coupon rate and up-front payments in the tranche
% structure in order to be able to apply Newton-Raphson to this function.
% --------------------------------------------------------------------------------------------------
% c                 ... vector of length 'num_tranches' with upfront payment of equity tranche and
%                       coupon rates for the o 
% tranche_structure ... tranche structure including portfolio (see 'all_steps_in_a_row.m')
% r_term            ... zero coupon rates, matching the quarterly coupon payment dates
% ajd_common_factor ... AJD dynamics of the common factor
% N                 ... number of points for numerical integration of transfrom
% dz                ... spacing for numerical integration of transform
% --------------------------------------------------------------------------------------------------
% sample call: mispricing_tranches([0.245 71 15.5 8 4.5], tranche_test, repmat(0.05, 20, 1), ajd_dynamics, 100, 1/100)
% --------------------------------------------------------------------------------------------------

tranche_structure.market_upfront(1) = c(1);
tranche_structure.market_prices(2:end) = c(2:end);
errors = value_fixed_leg_tranches(tranche_structure, r_term, ajd_common_factor, N, dz) - ...
        value_default_leg_tranches(tranche_structure, r_term, ajd_common_factor, N, dz);